
clear
set more off

*cd "N:\Private"
cd "C:\Data\SkyDrive\Dataset\2004-2005 Deliberative Polling\October_2004\data\"
use "fulldatav4.dta", clear

*======================================================
*generate wave indicator variable
*======================================================
gen wave = 2

*======================================================
*create site dummies
*======================================================

rename site sitename
gen site = .

gen sitedum1=0
gen sitedum2=0
gen sitedum3=0
gen sitedum4=0
gen sitedum5=0
gen sitedum6=0
gen sitedum7=0
gen sitedum8=0
gen sitedum9=0
gen sitedum10=0
gen sitedum11=0
gen sitedum12=0
gen sitedum13=0
gen sitedum14=0
gen sitedum15=0
gen sitedum16=0
gen sitedum17=0
gen sitedum18=0
gen sitedum19=0
gen sitedum20=0
gen sitedum21=0
gen sitedum22=0
gen sitedum23=0
gen sitedum24=0
gen sitedum25=0
gen sitedum26=0
gen sitedum27=0

replace sitedum11=1 if sitename=="CA"
replace sitedum12=1 if sitename=="CT"
replace sitedum13=1 if sitename=="FL"
replace sitedum14=1 if sitename=="ID"
replace sitedum15=1 if sitename=="KC"
replace sitedum16=1 if sitename=="KY"
replace sitedum17=1 if sitename=="LA"
replace sitedum18=1 if sitename=="MI"
replace sitedum19=1 if sitename=="NE"
replace sitedum20=1 if sitename=="NM"
replace sitedum21=1 if sitename=="NY"
replace sitedum22=1 if sitename=="OH"
replace sitedum23=1 if sitename=="PA"
replace sitedum24=1 if sitename=="SL"
replace sitedum25=1 if sitename=="TX"
replace sitedum26=1 if sitename=="VA"
replace sitedum27=1 if sitename=="WA"

replace site=11 if sitename=="CA"
replace site=12 if sitename=="CT"
replace site=13 if sitename=="FL"
replace site=14 if sitename=="ID"
replace site=15 if sitename=="KC"
replace site=16 if sitename=="KY"
replace site=17 if sitename=="LA"
replace site=18 if sitename=="MI"
replace site=19 if sitename=="NE"
replace site=20 if sitename=="NM"
replace site=21 if sitename=="NY"
replace site=22 if sitename=="OH"
replace site=23 if sitename=="PA"
replace site=24 if sitename=="SL"
replace site=25 if sitename=="TX"
replace site=26 if sitename=="VA"
replace site=27 if sitename=="WA"

drop sitename

gen sitegroup=site*100+group


*======================================================
*INDIVIDUAL-LEVEL INDEPENDENT VARIABLES
*======================================================

*Female*
gen female=gender
recode female (2=1) (1=0) (3/.=.)
drop if female>1

*age*
recode pre14 (9999=.)
gen age = 2004-pre14

*young*
gen young = age<40
drop if young>1

*Education*
gen education = pre12

*College*
gen college = pre12
recode college (1/3=0) (4/7=1) (8/.=.)
drop if college>1

*NoCollege*
gen nocollege = 1-college

*White*
gen white=pre16
recode white (1/3=0) (4=1) (5/6=0) (7/.=.)
drop if white>1

*Black*
gen black=pre16
recode black (1=0) (2=1) (3/6=0) (7/.=.)

*Nonwhite*
gen nonwhite=1-white

*Democract*
gen democrat=pre15
recode democrat (2/4=0) (5=.)

*Republican*
gen republican=pre15
recode republican (1=0) (2=1) (3/4=0) (5/.=.)


/* ==============================================================================================*/
/* ==============================================================================================*/
/* GROUP COMPOSITION */
/* female (prop_female / n_female / presence_female)*/
/* age (av_age)*/
/* young (prop_young / n_young / presence_young) */
/* whites (prop_white / n_white / presence_white)*/
/* nonwhites (prop_nonwhite / n_nonwhite / presence_nonwhite)*/
/* blacks (prop_black / n_black / presence_black)*/
/* college (prop_college / n_college / presence_college)*/
/* nocollege (prop_nocollege / n_nocollege / presence_nocollege)*/
/* education (av_edu)*/
/* democrats (prop_democrat / n_democrat / presence_democrat)*/
/* republican (prop_republican / n_republican / presence_republican)*/
/* ==============================================================================================*/
/* ==============================================================================================*/

set more off

drop if group== .

sort site group

*sequence of people in the group*
*also counts the number of people in each group*
by site group: egen counter = seq()

gen n_female = .
gen av_age = .
gen n_young = .
gen n_white = .
gen n_nonwhite = .
gen n_black = .
gen n_college = .
gen n_nocollege = .
gen av_edu = .
gen n_democrat = .
gen n_republican = .

sum counter	/*sum = summarize, not summation*/
scalar end = r(max)	/*gets the largest number of people across groups*/

local i = 1
while `i' < scalar(end)+1 {

gen tempfemale = 1 if female==1
gen tempage = age
gen tempyoung = 1 if young==1
gen tempwhite = 1 if white==1
gen tempnonwhite = 1 if nonwhite==1
gen tempblack = 1 if black==1
gen tempcollege = 1 if college==1
gen tempnocollege = 1 if nocollege==1
gen tempedu = education
gen tempdem = 1 if democrat==1
gen temprep = 1 if republican==1

replace tempfemale = . if counter==`i'	/*discount self*/
replace tempage = . if counter==`i' 	/*discount self*/
replace tempyoung = . if counter==`i'	/*discount self*/
replace tempwhite = . if counter==`i'	/*discount self*/
replace tempnonwhite = . if counter==`i'	/*discount self*/
replace tempblack = . if counter==`i'	/*discount self*/
replace tempcollege = . if counter==`i'	/*discount self*/
replace tempnocollege = . if counter==`i'	/*discount self*/
replace tempedu = . if counter==`i'	/*discount self*/
replace tempdem = . if counter==`i'	/*discount self*/
replace temprep = . if counter==`i'	/*discount self*/

by site group: egen samplefemale = count(tempfemale)
by site group: egen sampleage = mean(tempage)
by site group: egen sampleyoung = count(tempyoung)
by site group: egen samplewhite = count(tempwhite)
by site group: egen samplenonwhite = count(tempnonwhite)
by site group: egen sampleblack = count(tempblack)
by site group: egen samplecollege = count(tempcollege)
by site group: egen samplenocollege = count(tempnocollege)
by site group: egen sampleedu = mean(tempedu)
by site group: egen sampledem = count(tempdem)
by site group: egen samplerep = count(temprep)

replace n_female = samplefemale if counter==`i'
replace av_age = sampleage if counter==`i'
replace n_young = sampleyoung if counter==`i'
replace n_white = samplewhite if counter==`i'
replace n_nonwhite = samplenonwhite if counter==`i'
replace n_black = sampleblack if counter==`i'
replace n_college = samplecollege if counter==`i'
replace n_nocollege = samplenocollege if counter==`i'
replace av_edu = sampleedu if counter==`i'
replace n_democrat = sampledem if counter==`i'
replace n_republican = samplerep if counter==`i'

drop temp* sample*

local i = `i'+1
}

*generate proportion variables*
bysort site group: egen grp_size = count(counter)
replace grp_size = grp_size-1
gen prop_female = n_female/grp_size
gen prop_young = n_young/grp_size
gen prop_white = n_white/grp_size
gen prop_nonwhite = n_nonwhite/grp_size
gen prop_black = n_black/grp_size
gen prop_college = n_college/grp_size
gen prop_nocollege = n_nocollege/grp_size
gen prop_democrat = n_dem/grp_size
gen prop_republican = n_rep/grp_size

*generate presence variables
gen presence_female = n_female>0
gen presence_white = n_white>0
gen presence_nonwhite = n_nonwhite>0
gen presence_black = n_black>0
gen presence_college = n_college>0
gen presence_nocollege = n_nocollege>0
gen presence_democrat = n_democrat>0
gen presence_republican = n_republican>0

scalar drop _all
drop counter
drop if grp_size==0


/* =============================================================================*/
/* DEPENDENT VARIABLES*/
/* =============================================================================*/

gen dv_whole = post57
gen dv_large_group = post58
gen dv_offsession = post59
gen dv_small_group = post60
recode dv_whole dv_large_group dv_offsession dv_small_group (0=.) (11/.=.)
gen dv_respect = post67
gen dv_efficacy = post68
recode dv_respect dv_efficacy (0=.) (5/.=.)
gen dv_general = (dv_whole + dv_offsession + dv_small_group)/3

/*all mod variables are coded so that higher score reflects better moderator*/
/*That is, encouraging participation, not influencing participant, not pursuing consensus*/
gen mod_participation = post61
gen mod_influence = post62
gen mod_pursueagreement = post63
recode mod_* (0=.) (6/.=.)
recode mod_participation (1=5) (2=4) (4=2) (5=1)

*======================================================
*drop unused variables
*======================================================
drop recnum-_merge

cd "C:\Data\Dropbox\Research\2014- Deliberative Polling\Analysis\Replication"
save "04OctoberToJoin.dta"

append using "04JanuaryToJoin.dta"

save "04Combined.dta"
